/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.actions.TargetValidator;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;
import net.minecraftforge.installer.ui.TranslatedMessage;

public class ServerInstall
extends Action {
    public static boolean serverStarterJar;
    private final List<Artifact> grabbed = new ArrayList<Artifact>();

    public ServerInstall(InstallV1 profile, ProgressCallback monitor) {
        super(profile, monitor, false);
    }

    @Override
    public boolean run(File target, Predicate<String> optionals, File installer) throws ActionCanceledException {
        if (target.exists() && !target.isDirectory()) {
            this.error("There is a file at this location, the server cannot be installed here!");
            return false;
        }
        File librariesDir = new File(target, "libraries");
        if (!target.exists()) {
            target.mkdirs();
        }
        librariesDir.mkdir();
        if (this.profile.getMirror() != null && this.profile.getMirror().isAdvertised()) {
            this.monitor.stage(this.getSponsorMessage());
        }
        this.checkCancel();
        this.monitor.stage("Considering Minecraft server jar", true);
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("ROOT", target.getAbsolutePath());
        tokens.put("MINECRAFT_VERSION", this.profile.getMinecraft());
        tokens.put("LIBRARY_DIR", librariesDir.getAbsolutePath());
        String path = Util.replaceTokens(tokens, this.profile.getServerJarPath());
        File serverTarget = new File(path);
        if (!serverTarget.exists()) {
            File parent = serverTarget.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File versionJson = new File(target, this.profile.getMinecraft() + ".json");
            Version vanilla = Util.getVanillaVersion(this.monitor, this.profile.getMinecraft(), versionJson);
            if (vanilla == null) {
                this.error("Failed to download version manifest, can not find server jar URL.");
                return false;
            }
            Version.Download server = vanilla.getDownload("server");
            if (server == null) {
                this.error("Failed to download minecraft server, info missing from manifest: " + versionJson);
                return false;
            }
            versionJson.delete();
            if (!this.monitor.downloader(server.getUrl()).sha(server.getSha1()).localPath("minecraft/" + this.profile.getMinecraft() + "/server.jar").download(serverTarget)) {
                serverTarget.delete();
                this.error("Downloading minecraft server failed, invalid checksum.\nTry again, or manually place server jar to skip download.");
                return false;
            }
        }
        this.checkCancel();
        ArrayList<File> libDirs = new ArrayList<File>();
        File mcLibDir = new File(SimpleInstaller.getMCDir(), "libraries");
        if (mcLibDir.exists()) {
            libDirs.add(mcLibDir);
        }
        if (!this.downloadLibraries(librariesDir, optionals, libDirs)) {
            return false;
        }
        this.checkCancel();
        if (!this.processors.process(librariesDir, serverTarget, target, installer)) {
            return false;
        }
        if (serverStarterJar) {
            this.monitor.downloader("https://github.com/NeoForged/serverstarterjar/releases/latest/download/server.jar").localPath("serverstarter.jar").download(new File(target, "server.jar"));
        }
        return true;
    }

    @Override
    public TargetValidator getTargetValidator() {
        return TargetValidator.shouldExist(false).and(TargetValidator.isDirectory()).and(TargetValidator.shouldBeEmpty());
    }

    @Override
    public TranslatedMessage getSuccessMessage() {
        if (this.grabbed.isEmpty()) {
            return new TranslatedMessage("installer.action.install.server.finished.withoutlibs", this.profile.getVersion());
        }
        return new TranslatedMessage("installer.action.install.server.finished.withlibs", this.grabbed.size(), this.profile.getVersion());
    }
}

