/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

public interface IProcessingBlock {
    default public EnergyMode getEnergyMode() {
        return EnergyMode.ONLY_WHEN_PROCESSING;
    }

    public int getEnergy();

    public void addEnergy(int var1);

    public boolean requiresEnergy();

    public int retrieveEnergy(boolean var1);

    public int updateAndGetTotalProcessingTime();

    public int getTotalProcessingTime();

    public int getProcessingTime();

    public void setProcessingTime(int var1);

    public void onCompleteProcess();

    public boolean canProcess();

    default public boolean processTick() {
        boolean processing = false;
        if (this.canProcess()) {
            if (this.requiresEnergy() && this.getEnergy() <= 0 && this.retrieveEnergy(true) > 0) {
                this.addEnergy(this.retrieveEnergy(false));
            }
            if (!this.requiresEnergy() || this.getEnergy() > 0) {
                processing = true;
                int totalProcessingTime = this.updateAndGetTotalProcessingTime();
                int processingTime = this.getProcessingTime();
                if (processingTime < totalProcessingTime) {
                    this.setProcessingTime(processingTime + 1);
                    if (this.requiresEnergy() && this.getEnergyMode() == EnergyMode.ONLY_WHEN_PROCESSING) {
                        this.addEnergy(-1);
                    }
                }
                if (processingTime >= totalProcessingTime) {
                    this.onCompleteProcess();
                    this.setProcessingTime(0);
                }
            }
        }
        if (this.requiresEnergy() && this.getEnergyMode() == EnergyMode.ALWAYS_CONSUME && this.getEnergy() > 0) {
            this.addEnergy(-1);
        }
        if (!processing) {
            this.setProcessingTime(0);
        }
        return processing;
    }

    public static enum EnergyMode {
        ALWAYS_CONSUME,
        ONLY_WHEN_PROCESSING;

    }
}

