/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class ServerAdminRequestPropPacket {
    private Integer type;
    private String payload;
    private String dimension;
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"admin_req");
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerAdminRequestPropPacket> STREAM_CODEC = StreamCodec.ofMember(ServerAdminRequestPropPacket::encode, ServerAdminRequestPropPacket::new);

    public ServerAdminRequestPropPacket() {
    }

    public ServerAdminRequestPropPacket(Integer type, String payload, String dimension) {
        this.payload = payload;
        this.type = type;
        this.dimension = dimension;
    }

    public ServerAdminRequestPropPacket(Integer type, String dimension) {
        this(type, "", dimension);
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public int getType() {
        return this.type;
    }

    public String getPayload() {
        return this.payload;
    }

    public ServerAdminRequestPropPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                this.type = buf.readInt();
                this.dimension = buf.readUtf(Short.MAX_VALUE);
                this.payload = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for server admin request: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null && this.type != null && this.dimension != null) {
                buf.writeByte(42);
                buf.writeInt(this.type.intValue());
                buf.writeUtf(this.dimension);
                buf.writeUtf(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for server admin request:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<ServerAdminRequestPropPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onAdminScreenOpen(ctx.sender(), ((ServerAdminRequestPropPacket)ctx.message()).getType(), ((ServerAdminRequestPropPacket)ctx.message()).dimension);
        } else {
            JourneymapClient.getInstance().getPacketHandler().onServerAdminDataResponse(((ServerAdminRequestPropPacket)ctx.message()).getType(), ((ServerAdminRequestPropPacket)ctx.message()).getPayload(), ((ServerAdminRequestPropPacket)ctx.message()).dimension);
        }
    }
}

