/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.waypoint;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Map;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.codecs.WaypointGroupCodecs;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public abstract class WaypointDAO {
    protected static final String GROUPS = "groups";
    protected static final String WAYPOINTS = "waypoints";
    protected CompoundTag data;
    private boolean dirty = false;

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public abstract Map<String, WaypointGroupImpl> decodeGroups(CompoundTag var1);

    public abstract CompoundTag encodeGroups(Collection<WaypointGroupImpl> var1);

    public abstract Map<String, WaypointImpl> decodeWaypoints(CompoundTag var1);

    public abstract CompoundTag encodeWaypoints(Collection<WaypointImpl> var1);

    public abstract void save(boolean var1);

    public void deleteGroup(WaypointGroup group) {
        this.setDirty(true);
        this.data.getCompound(GROUPS).remove(group.getGuid());
    }

    public void deleteWaypoint(WaypointImpl waypoint) {
        this.setDirty(true);
        this.data.getCompound(WAYPOINTS).remove(waypoint.getGuid());
    }

    public void addGroup(WaypointGroup group) {
        DataResult result;
        this.setDirty(true);
        if (!this.data.contains(GROUPS)) {
            this.data.put(GROUPS, (Tag)new CompoundTag());
        }
        if ((result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((WaypointGroupImpl)group))).result().isPresent()) {
            this.data.getCompound(GROUPS).put(group.getGuid(), (Tag)result.result().get());
        }
    }

    public void addWaypoint(WaypointImpl waypoint) {
        DataResult result;
        this.setDirty(true);
        if (!this.data.contains(WAYPOINTS)) {
            this.data.put(WAYPOINTS, (Tag)new CompoundTag());
        }
        if ((result = WaypointCodecs.V1_WAYPOINT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)waypoint)).result().isPresent()) {
            this.data.getCompound(WAYPOINTS).put(waypoint.getGuid(), (Tag)result.result().get());
        }
    }

    public abstract Map<String, WaypointGroupImpl> getGroups();

    public abstract Map<String, WaypointImpl> getWaypoints();

    public abstract WaypointImpl decodeWaypoint(Tag var1);

    public abstract Tag encodeWaypoint(WaypointImpl var1);

    public abstract WaypointImpl copyWaypoint(WaypointImpl var1);
}

