/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class IgnSkin {
    private static final Map<UUID, NativeImage> faceImageCache = Maps.newHashMap();
    private static final Map<URL, CompletableFuture<NativeImage>> imageRequests = Maps.newConcurrentMap();

    public static NativeImage getFaceImage(GameProfile profile) {
        boolean firstPass;
        String username = profile.getName();
        boolean bl = firstPass = !faceImageCache.containsKey(profile.getId());
        if (firstPass) {
            faceImageCache.put(profile.getId(), null);
            SkullBlockEntity.fetchGameProfile((String)username).thenAccept(optional -> {
                GameProfile gameProfile = optional.orElse(new GameProfile(Util.NIL_UUID, username));
                try {
                    MinecraftSessionService mss = Minecraft.getInstance().getMinecraftSessionService();
                    MinecraftProfileTextures textures = mss.getTextures(gameProfile);
                    if (textures != null) {
                        Journeymap.getLogger().debug("Retrieved skin for {} : {}", (Object)profile.getId(), (Object)username);
                        MinecraftProfileTexture mpt = textures.skin();
                        IgnSkin.getImageFromUrl(new URL(mpt.getUrl()), image -> faceImageCache.put(profile.getId(), IgnSkin.cropToFace(image)));
                    } else {
                        Journeymap.getLogger().debug("Unable to retrieve skin for {} : {}", (Object)profile.getId(), (Object)profile.getName());
                        ResourceLocation resourceLocation = DefaultPlayerSkin.get((UUID)profile.getId()).texture();
                        NativeImage skinImage = TextureCache.getTexture(resourceLocation).getPixels();
                        faceImageCache.put(profile.getId(), IgnSkin.cropToFace(skinImage));
                    }
                }
                catch (Throwable e) {
                    Journeymap.getLogger().warn("Error getting face image for " + profile.getName() + ": " + e.getMessage());
                }
            });
        }
        return faceImageCache.get(profile.getId());
    }

    private static void getImageFromUrl(URL imageURL, Consumer<NativeImage> imageConsumer) {
        CompletableFuture<NativeImage> future = imageRequests.get(imageURL);
        if (future != null) {
            imageRequests.put(imageURL, (CompletableFuture<NativeImage>)future.whenCompleteAsync((image, throwable) -> imageConsumer.accept((NativeImage)image), (Executor)Util.backgroundExecutor()));
        } else {
            imageRequests.put(imageURL, (CompletableFuture<NativeImage>)CompletableFuture.supplyAsync(() -> IgnSkin.downloadImage(imageURL), Util.backgroundExecutor()).whenCompleteAsync((image, throwable) -> imageConsumer.accept((NativeImage)image), (Executor)Util.backgroundExecutor()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeImage downloadImage(URL imageURL) {
        NativeImage img = null;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)imageURL.openConnection(Minecraft.getInstance().getProxy());
            HttpURLConnection.setFollowRedirects(true);
            conn.setInstanceFollowRedirects(true);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setReadTimeout(3000);
            conn.setConnectTimeout(3000);
            conn.connect();
            if (conn.getResponseCode() / 100 == 2) {
                img = NativeImage.read((InputStream)conn.getInputStream());
            } else {
                Journeymap.getLogger().debug("Bad Response getting image: " + String.valueOf(imageURL) + " : " + conn.getResponseCode());
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error getting skin image: " + String.valueOf(imageURL) + " : " + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        Journeymap.getLogger().debug("Getting Skin for URL: {}", (Object)imageURL);
        return img;
    }

    private static NativeImage cropToFace(NativeImage playerSkin) {
        if (playerSkin != null) {
            if (playerSkin.format().hasAlpha()) {
                NativeImage hat = ImageUtil.getSubImage(40, 8, 8, 8, playerSkin, false);
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        int hatPixel = hat.getPixelRGBA(x, y);
                        playerSkin.blendPixel(x + 8, y + 8, hatPixel);
                    }
                }
                hat.close();
            }
            NativeImage sub = ImageUtil.getSubImage(8, 8, 8, 8, playerSkin, true);
            return ImageUtil.getSizedImage(24, 24, sub, true);
        }
        return new NativeImage(24, 24, false);
    }
}

