/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.impl;

import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.IModBlockHandler;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ImmersiveRailroading
implements IModBlockHandler,
IBlockColorProxy {
    private static final int RAIL_COLOR = 0xDCDCDC;
    private static final int RAIL_COLOR_PREVIEW = 0x7D7D7D;

    @Override
    public void initialize(BlockMD blockMD) {
        blockMD.setBlockColorProxy(this);
        String name = blockMD.getBlockId().toLowerCase();
        if (name.equalsIgnoreCase("block_rail_preview")) {
            blockMD.setColor(0x7D7D7D);
        } else if (name.contains("block_rail") || name.contains("multiblock")) {
            blockMD.setColor(0xDCDCDC);
        }
    }

    @Override
    @Nullable
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        String name = blockMD.getBlockId().toLowerCase();
        if (name.equalsIgnoreCase("block_rail_preview")) {
            return 0x7D7D7D;
        }
        if (name.contains("block_rail") || name.contains("multiblock")) {
            return 0xDCDCDC;
        }
        return Minecraft.getInstance().getBlockColors().getColor(blockMD.getBlockState(), (Level)chunkMD.getWorld(), blockPos);
    }
}

