/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.FileUtils;

public class FileHandler {
    public static final String DEV_MINECRAFT_DIR = "run/";
    public static final String ASSETS_JOURNEYMAP = "/assets/journeymap";
    public static final String ASSETS_JOURNEYMAP_UI = "/assets/journeymap/ui";
    public static final String ASSETS_WEBMAP = "/assets/journeymap/web";
    public static final File MinecraftDirectory = FileHandler.getMinecraftDirectory();
    public static final File JourneyMapDirectory = new File(MinecraftDirectory, Constants.JOURNEYMAP_DIR);
    public static final File StandardConfigDirectory = new File(MinecraftDirectory, Constants.CONFIG_DIR);
    private static Boolean oldOverworldDir;
    private static Boolean oldNetherDir;
    private static Boolean oldEndDir;
    private static File lastWorldDir;

    public static File getMinecraftDirectory() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            return minecraft.gameDirectory;
        }
        return new File(DEV_MINECRAFT_DIR);
    }

    public static Path getDimPath(File worldDir, ResourceKey<Level> dimensionKey) {
        return new File(worldDir, FileHandler.getDimNameForPath(worldDir, dimensionKey)).toPath();
    }

    public static String getDimNameForPath(File worldDir, ResourceKey<Level> dimensionKey) {
        if (oldEndDir == null || oldNetherDir == null || oldOverworldDir == null || lastWorldDir != worldDir) {
            lastWorldDir = worldDir;
            oldEndDir = new File(worldDir, "DIM1").exists();
            oldNetherDir = new File(worldDir, "DIM-1").exists();
            oldOverworldDir = new File(worldDir, "DIM0").exists();
        }
        if (Level.OVERWORLD.equals(dimensionKey) && oldOverworldDir.booleanValue()) {
            return "DIM0";
        }
        if (Level.END.equals(dimensionKey) && oldEndDir.booleanValue()) {
            return "DIM1";
        }
        if (Level.NETHER.equals(dimensionKey) && oldNetherDir.booleanValue()) {
            return "DIM-1";
        }
        return FileHandler.getPathDimensionName(dimensionKey);
    }

    public static String getPathDimensionName(ResourceKey<Level> dimensionKey) {
        if ("minecraft".equals(dimensionKey.location().getNamespace())) {
            return DimensionHelper.getDimName(dimensionKey);
        }
        return CommonConstants.getSafeString(dimensionKey.location().toString(), "~");
    }

    public static File getMCWorldDir(Minecraft minecraft) {
        if (minecraft.isLocalServer()) {
            String lastMCFolderName = minecraft.getSingleplayerServer().storageSource.getLevelId();
            File lastMCWorldDir = new File(FileHandler.getMinecraftDirectory(), "saves" + File.separator + lastMCFolderName);
            return lastMCWorldDir;
        }
        return null;
    }

    public static File getWorldSaveDir(Minecraft minecraft) {
        if (minecraft.hasSingleplayerServer()) {
            try {
                ResourceKey provider = minecraft.level.dimension();
                File savesDir = new File(FileHandler.getMinecraftDirectory(), "saves");
                File worldSaveDir = new File(savesDir, minecraft.getSingleplayerServer().storageSource.getLevelId());
                DimensionType.getStorageFolder((ResourceKey)provider, (Path)worldSaveDir.toPath());
                File dir = DimensionType.getStorageFolder((ResourceKey)provider, (Path)worldSaveDir.toPath()).toFile();
                dir.mkdirs();
                return dir;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error getting world save dir: %s", t);
            }
        }
        return null;
    }

    public static File getMCWorldDir(Minecraft minecraft, ResourceKey<Level> dimension) {
        File worldDir = FileHandler.getMCWorldDir(minecraft);
        return DimensionType.getStorageFolder(dimension, (Path)worldDir.toPath()).toFile();
    }

    public static File getJourneyMapDir() {
        return JourneyMapDirectory;
    }

    public static File getJMWorldDir(Minecraft minecraft) {
        if (minecraft.level == null) {
            return null;
        }
        return FileHandler.getJMWorldDir(minecraft, JourneymapClient.getInstance().getCurrentWorldId());
    }

    public static File getAddonDataPath(Minecraft minecraft) {
        return new File(FileHandler.getJMWorldDir(minecraft), "addon-data");
    }

    public static synchronized File getJMWorldDir(Minecraft minecraft, String worldId) {
        if (minecraft.level == null) {
            return null;
        }
        File worldDirectory = null;
        try {
            worldDirectory = FileHandler.getJMWorldDirForWorldId(minecraft, worldId);
            if (worldDirectory == null) {
                worldDirectory = FileHandler.getJMWorldDirForWorldId(minecraft, null);
            }
            if (worldDirectory != null && !worldDirectory.exists()) {
                worldDirectory.mkdirs();
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().log(org.apache.logging.log4j.Level.ERROR, LogFormatter.toString(e));
            throw new RuntimeException(e);
        }
        return worldDirectory;
    }

    public static File getJMWorldDirForWorldId(Minecraft minecraft, String worldId) {
        if (minecraft == null || minecraft.level == null) {
            return null;
        }
        File testWorldDirectory = null;
        try {
            String suffix = FileHandler.getWorldDirectoryName(minecraft, worldId);
            if (!minecraft.hasSingleplayerServer()) {
                testWorldDirectory = new File(MinecraftDirectory, Constants.MP_DATA_DIR + suffix);
            } else {
                File legacyDirectory = new File(MinecraftDirectory, Constants.SP_DATA_DIR + suffix);
                testWorldDirectory = new File(MinecraftDirectory, Constants.SP_DATA_DIR + FileHandler.getWorldSaveFolderName());
                if (!testWorldDirectory.exists() && legacyDirectory.exists()) {
                    testWorldDirectory = legacyDirectory;
                }
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().log(org.apache.logging.log4j.Level.ERROR, LogFormatter.toString(e));
        }
        return testWorldDirectory;
    }

    public static String getWorldDirectoryName(Minecraft minecraft) {
        return FileHandler.getWorldDirectoryName(minecraft, JourneymapClient.getInstance().getCurrentWorldId());
    }

    public static String getWorldDirectoryName(Minecraft minecraft, String worldId) {
        if (minecraft == null || minecraft.level == null) {
            return null;
        }
        String worldName = CommonConstants.getSafeString(WorldData.getWorldName(minecraft), "~");
        if (!Strings.isNullOrEmpty((String)worldId)) {
            worldId = worldId.replaceAll("\\W+", "~");
        }
        Object suffix = !Strings.isNullOrEmpty((String)worldId) ? "_" + worldId : "";
        return worldName + (String)suffix;
    }

    private static String getWorldSaveFolderName() {
        File file = Minecraft.getInstance().getSingleplayerServer().getWorldPath(LevelResource.ROOT).toFile();
        String worldName = file.getParent().substring(file.getParent().lastIndexOf(File.separator) + 1);
        String worldId = JourneymapClient.getInstance().getCurrentWorldId();
        if (!Strings.isNullOrEmpty((String)worldId)) {
            worldId = worldId.replaceAll("\\W+", "~");
        }
        Object suffix = !Strings.isNullOrEmpty((String)worldId) ? "_" + worldId : "";
        return worldName + (String)suffix;
    }

    public static File getWaypointDir() {
        return FileHandler.getWaypointDir(FileHandler.getJMWorldDir(Minecraft.getInstance()));
    }

    public static File getWaypointDir(File jmWorldDir) {
        File waypointDir = new File(jmWorldDir, "waypoints");
        if (!waypointDir.isDirectory()) {
            waypointDir.delete();
        }
        if (!waypointDir.exists()) {
            waypointDir.mkdirs();
        }
        return waypointDir;
    }

    public static Properties getLangFile(String fileName) {
        try {
            InputStream is = JourneymapClient.class.getResourceAsStream("/assets/journeymap/lang/" + fileName);
            if (is == null) {
                File file = new File("../src/main/resources/assets/journeymap/lang/" + fileName);
                if (file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    Journeymap.getLogger().warn("Language file not found: " + fileName);
                    return null;
                }
            }
            Properties properties = new Properties();
            properties.load(is);
            is.close();
            return properties;
        }
        catch (IOException e) {
            String error = "Could not get language file " + fileName + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static <M> M getMessageModel(Class<M> model, String filePrefix) {
        try {
            String lang = Minecraft.getInstance().getLanguageManager().getSelected();
            InputStream is = FileHandler.getMessageModelInputStream(filePrefix, lang);
            if (is == null && !lang.equals("en_US")) {
                is = FileHandler.getMessageModelInputStream(filePrefix, "en_US");
            }
            if (is == null) {
                Journeymap.getLogger().warn("Message file not found: " + filePrefix);
                return null;
            }
            return (M)new GsonBuilder().create().fromJson((Reader)new InputStreamReader(is), model);
        }
        catch (Throwable e) {
            String error = "Could not get Message model " + filePrefix + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static InputStream getMessageModelInputStream(String filePrefix, String lang) {
        String file = String.format("/assets/journeymap/lang/message/%s-%s.json", filePrefix, lang);
        return JourneymapClient.class.getResourceAsStream(file);
    }

    public static File getWorldConfigDir(boolean fallbackToStandardConfigDir) {
        File worldConfigDir;
        File worldDir = FileHandler.getJMWorldDirForWorldId(Minecraft.getInstance(), null);
        if (worldDir != null && worldDir.exists() && (worldConfigDir = new File(worldDir, "config")).exists()) {
            return worldConfigDir;
        }
        return fallbackToStandardConfigDir ? StandardConfigDirectory : null;
    }

    public static boolean isInJar() {
        return FileHandler.isInJar(JourneymapClient.class.getProtectionDomain().getCodeSource().getLocation());
    }

    public static boolean isInJar(URL location) {
        if ("jar".equals(location.getProtocol())) {
            return true;
        }
        if ("file".equals(location.getProtocol())) {
            File file = new File(location.getFile());
            return file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
        }
        return false;
    }

    public static File copyColorPaletteHtmlFile(File toDir, String fileName) {
        try {
            final File outFile = new File(toDir, fileName);
            String htmlPath = "/assets/journeymap/ui/" + fileName;
            InputStream inputStream = JourneymapClient.class.getResource(htmlPath).openStream();
            ByteSink out = new ByteSink(){

                public OutputStream openStream() throws IOException {
                    return new FileOutputStream(outFile);
                }
            };
            out.writeFrom(inputStream);
            return outFile;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Couldn't copy color palette html: " + String.valueOf(t));
            return null;
        }
    }

    public static void open(File file) {
        String path = file.getAbsolutePath();
        if (Util.getPlatform() == Util.OS.OSX) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", path});
                return;
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Could not open path with /usr/bin/open: " + path + " : " + LogFormatter.toString(e));
            }
        } else if (Util.getPlatform() == Util.OS.WINDOWS) {
            String cmd = String.format("cmd.exe /C start \"Open file\" \"%s\"", path);
            try {
                Runtime.getRuntime().exec(cmd);
                return;
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Could not open path with cmd.exe: " + path + " : " + LogFormatter.toString(e));
            }
        }
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object method = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(method, file.toURI());
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Could not open path with Desktop: " + path + " : " + LogFormatter.toString(e));
            String url = "file://" + path;
            Util.getPlatform().openUri(url);
        }
    }

    public static boolean copyResources(File targetDirectory, ResourceLocation location, String setName, boolean overwrite) {
        Object fromPath = null;
        Object toDir = null;
        try {
            String domain = location.getNamespace();
            URL fileLocation = null;
            fileLocation = domain.equals("minecraft") ? Minecraft.class.getProtectionDomain().getCodeSource().getLocation() : Services.COMMON_SERVICE.getModFileLocation(domain);
            if (fileLocation != null) {
                String assetsPath;
                if (location.getPath().startsWith("assets/")) {
                    assetsPath = location.getPath();
                } else {
                    if ("journeymap_webmap".equals(domain)) {
                        domain = "journeymap";
                    }
                    assetsPath = String.format("assets/%s/%s", domain, location.getPath());
                }
                return FileHandler.copyResources(targetDirectory, fileLocation, assetsPath, setName, overwrite);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Couldn't get resource set from %s to %s: %s", fromPath, toDir, t));
        }
        return false;
    }

    public static boolean copyResources(File targetDirectory, URL resourceDir, String assetsPath, String setName, boolean overwrite) {
        String fromPath = null;
        File toDir = null;
        try {
            toDir = new File(targetDirectory, setName);
            boolean inJar = FileHandler.isInJar(resourceDir);
            if (inJar) {
                if ("jar".equals(resourceDir.getProtocol()) || resourceDir.toString().endsWith(".jar")) {
                    fromPath = URLDecoder.decode(resourceDir.getPath(), StandardCharsets.UTF_8);
                    if (fromPath.contains("file:")) {
                        fromPath = fromPath.split("file:")[1];
                    }
                    if (fromPath.contains("!/")) {
                        fromPath = fromPath.split("!/")[0];
                    }
                    if (fromPath.startsWith("/")) {
                        fromPath = fromPath.substring(1);
                    }
                } else {
                    fromPath = new File(resourceDir.getPath()).getPath();
                }
                return FileHandler.copyFromZip(fromPath, assetsPath, toDir, overwrite);
            }
            File fromDir = new File(resourceDir.getFile(), assetsPath);
            if (fromDir.exists()) {
                fromPath = fromDir.getPath();
                return FileHandler.copyFromDirectory(fromDir, toDir, overwrite);
            }
            Journeymap.getLogger().error("Couldn't locate icons for {}: {}", (Object)setName, (Object)fromDir);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't unzip resource set from {} to {}:", fromPath, (Object)toDir, (Object)t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean copyFromZip(String zipFilePath, String zipEntryName, File destDir, boolean overWrite) throws Throwable {
        Object fromPath = URLDecoder.decode(zipFilePath, StandardCharsets.UTF_8).replace("file://", "");
        if (zipEntryName.startsWith("/")) {
            zipEntryName = zipEntryName.substring(1);
        }
        if (Minecraft.ON_OSX && !((String)fromPath).startsWith("//")) {
            fromPath = ((String)fromPath).startsWith("/") ? "/" + (String)fromPath : "//" + (String)fromPath;
        }
        ZipFile zipFile = new ZipFile((String)fromPath);
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream((String)fromPath));
        ZipEntry entry = zipIn.getNextEntry();
        boolean success = false;
        try {
            while (entry != null) {
                if (entry.getName().startsWith(zipEntryName)) {
                    File toFile = new File(destDir, entry.getName().split(zipEntryName)[1]);
                    if (!(!overWrite && toFile.exists() || entry.isDirectory())) {
                        Files.createParentDirs((File)toFile);
                        new ZipEntryByteSource(zipFile, entry).copyTo(Files.asByteSink((File)toFile, (FileWriteMode[])new FileWriteMode[0]));
                        success = true;
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            zipIn.close();
        }
        return success;
    }

    static boolean copyFromDirectory(File fromDir, File toDir, boolean overWrite) throws IOException {
        if (!toDir.exists() && !toDir.mkdirs()) {
            throw new IOException("Couldn't create directory: " + String.valueOf(toDir));
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(String.valueOf(fromDir) + " nas no files");
        }
        boolean success = true;
        for (File from : files) {
            File to = new File(toDir, from.getName());
            if (from.isDirectory()) {
                if (FileHandler.copyFromDirectory(from, to, overWrite)) continue;
                success = false;
                continue;
            }
            if (!overWrite && to.exists()) continue;
            Files.copy((File)from, (File)to);
            if (to.exists()) continue;
            success = false;
        }
        return success;
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            Journeymap.getLogger().error(String.format("Could not delete file:", LogFormatter.toString(e)));
        }
        return file.exists();
    }

    public static NativeImage getIconFromFile(File parentdir, String setName, String iconPath) {
        NativeImage img = null;
        if (iconPath == null) {
            iconPath = "null";
        }
        File iconFile = null;
        try {
            String filePath = Joiner.on((char)File.separatorChar).join((Object)setName, (Object)iconPath.replace('/', File.separatorChar), new Object[0]);
            iconFile = new File(parentdir, filePath);
            if (iconFile.exists()) {
                FileInputStream is = new FileInputStream(iconFile.getPath());
                img = NativeImage.read((InputStream)is);
            }
        }
        catch (Exception e) {
            JMLogger.throwLogOnce("Couldn't load iconset file: " + String.valueOf(iconFile), e);
        }
        return img;
    }

    private static File getMobIconsDir() {
        File dir = new File(FileHandler.getMinecraftDirectory(), Constants.ENTITY_ICON_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File[] getMobIconsDomainsDirectories() {
        File parentDir = FileHandler.getMobIconsDir();
        File[] domainsDirs = parentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return domainsDirs;
    }

    public static File getMobIconsDomainsDirectory(ResourceLocation mobLocation) {
        File dir;
        File mobsDir = new File(FileHandler.getMinecraftDirectory(), Constants.ENTITY_ICON_DIR);
        if (!mobsDir.exists()) {
            mobsDir.mkdirs();
        }
        if (!(dir = new File(mobsDir, mobLocation.getNamespace())).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static NativeImage getImageFromFile(File file) {
        try {
            FileInputStream is = new FileInputStream(file.getPath());
            return FileHandler.getImageFromStream(is);
        }
        catch (IOException e) {
            String error = "Could not get image from file: " + String.valueOf(file) + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static NativeImage getImageFromStream(InputStream stream) {
        try {
            return NativeImage.read((InputStream)stream);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class ZipEntryByteSource
    extends ByteSource {
        final ZipFile file;
        final ZipEntry entry;

        ZipEntryByteSource(ZipFile file, ZipEntry entry) {
            this.file = file;
            this.entry = entry;
        }

        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        public String toString() {
            return String.format("ZipEntryByteSource( %s / %s )", this.file, this.entry);
        }
    }
}

