/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class MixedNameGenerator
implements NameGenerator {
    private final List<NameGenerator> nameGenerators;

    public MixedNameGenerator(NameGenerator ... nameGenerators) {
        this.nameGenerators = Arrays.asList(nameGenerators);
    }

    @Override
    public Optional<Component> generateName(LevelAccessor level, Waystone waystone, RandomSource rand) {
        Collections.shuffle(this.nameGenerators);
        for (NameGenerator nameGenerator : this.nameGenerators) {
            Optional<Component> name = nameGenerator.generateName(level, waystone, rand);
            if (!name.isPresent()) continue;
            return name;
        }
        return Optional.empty();
    }
}

