/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WaystoneEditMenu
extends AbstractContainerMenu {
    public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC.cast(), Data::pos, WaystoneImpl.STREAM_CODEC, Data::waystone, (StreamCodec)ByteBufCodecs.INT, Data::modifierCount, (StreamCodec)ByteBufCodecs.BOOL, Data::canEdit, Data::new);
    private final Waystone waystone;
    private final WaystoneBlockEntityBase blockEntity;
    private final int modifierCount;
    private final boolean canEdit;

    public WaystoneEditMenu(int windowId, Waystone waystone, WaystoneBlockEntityBase blockEntity, Inventory playerInventory, int modifierCount, boolean canEdit) {
        super((MenuType)ModMenus.waystoneSettings.get(), windowId);
        this.waystone = waystone;
        this.blockEntity = blockEntity;
        this.modifierCount = modifierCount;
        this.canEdit = canEdit;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index < 5 ? !this.moveItemStackTo(slotStack, 5, this.slots.size(), true) : (!this.getSlot(0).hasItem() ? !this.moveItemStackTo(slotStack.split(1), 0, 1, false) : !this.moveItemStackTo(slotStack, 1, 5, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.blockEntity.getBlockPos();
        return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }

    public Waystone getWaystone() {
        return this.waystone;
    }

    public int getModifierCount() {
        return this.modifierCount;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public record Data(BlockPos pos, Waystone waystone, int modifierCount, boolean canEdit) {
    }
}

