/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.PortstoneBlockEntity;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PortstoneBlock
extends WaystoneBlockBase {
    public static final MapCodec<PortstoneBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(PortstoneBlock::getColor), (App)PortstoneBlock.propertiesCodec()).apply((Applicative)instance, PortstoneBlock::new));
    private static final VoxelShape[] LOWER_SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)7.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)7.0, (double)12.0, (double)16.0, (double)10.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)10.0, (double)12.0, (double)12.0, (double)12.0)}).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)9.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), PortstoneBlock.box((double)6.0, (double)9.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0)}).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)3.0, (double)9.0, (double)9.0, (double)13.0, (double)16.0, (double)13.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)6.0, (double)12.0, (double)16.0, (double)9.0), PortstoneBlock.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)12.0, (double)6.0)}).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PortstoneBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), PortstoneBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), PortstoneBlock.box((double)3.0, (double)9.0, (double)3.0, (double)7.0, (double)16.0, (double)13.0), PortstoneBlock.box((double)7.0, (double)9.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), PortstoneBlock.box((double)10.0, (double)9.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)}).optimize()};
    private static final VoxelShape[] UPPER_SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)PortstoneBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)7.0), (VoxelShape)PortstoneBlock.box((double)4.0, (double)0.0, (double)7.0, (double)12.0, (double)2.0, (double)9.0)).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)9.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape)PortstoneBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)2.0, (double)12.0)).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)3.0, (double)0.0, (double)9.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape)PortstoneBlock.box((double)4.0, (double)0.0, (double)7.0, (double)12.0, (double)2.0, (double)9.0)).optimize(), Shapes.or((VoxelShape)PortstoneBlock.box((double)3.0, (double)0.0, (double)3.0, (double)7.0, (double)7.0, (double)13.0), (VoxelShape)PortstoneBlock.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)2.0, (double)12.0)).optimize()};
    private final DyeColor color;

    public PortstoneBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPES[direction.get2DDataValue()] : LOWER_SHAPES[direction.get2DDataValue()];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PortstoneBlockEntity(pos, state);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!world.isClientSide) {
            ResourceLocation targetWaystoneType = this.getTargetWaystoneType();
            final Collection<Waystone> waystones = PlayerWaystoneManager.getTargetsForWaystoneType(player, targetWaystoneType);
            PlayerWaystoneManager.ensureSortingIndex(player, waystones);
            Balm.getNetworking().openGui(player, (MenuProvider)new BalmMenuProvider<Collection<Waystone>>(){

                public Component getDisplayName() {
                    return Component.translatable((String)("container.waystones." + PortstoneBlock.this.color.getSerializedName() + "_portstone"));
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.portstoneSelection.get()), null, windowId, waystones, Collections.emptySet());
                }

                public Collection<Waystone> getScreenOpeningData(ServerPlayer serverPlayer) {
                    return waystones;
                }

                public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getScreenStreamCodec() {
                    return WaystoneImpl.LIST_STREAM_CODEC;
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    private ResourceLocation getTargetWaystoneType() {
        return WaystoneTypes.getSharestone(this.color).orElse(WaystoneTypes.WAYSTONE);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        MutableComponent component = Component.translatable((String)"tooltip.waystones.portstone");
        component.withStyle(ChatFormatting.GRAY);
        list.add((Component)component);
        super.appendHoverText(stack, context, list, flag);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

