/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.recipes;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class EnergyFluidProducerRecipe
implements Recipe<RecipeInput> {
    protected final RecipeType<?> type;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final String group;
    protected final int fluidAmount;
    protected final int energy;
    protected final int duration;

    public EnergyFluidProducerRecipe(RecipeType<?> type, String group, Ingredient ingredientIn, ItemStack result, int fluidAmount, int energy, int duration) {
        this.type = type;
        this.group = group;
        this.ingredient = ingredientIn;
        this.result = result;
        this.fluidAmount = fluidAmount;
        this.energy = energy;
        this.duration = duration;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return this.ingredient.test(inv.getItem(0));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean isSpecial() {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.result.copy();
    }

    public NonNullList<ItemStack> getRemainingItems(RecipeInput inv) {
        return null;
    }

    public String getGroup() {
        return this.group;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getDuration() {
        return this.duration;
    }

    public RecipeType<?> getType() {
        return this.type;
    }
}

