/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityEnergyFluidProducer;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerEnergyFluidProducer;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public abstract class GuiEnergyFluidProducer<T extends ContainerEnergyFluidProducer>
extends ScreenBase<T> {
    private Inventory playerInv;
    private TileEntityEnergyFluidProducer tile;

    public GuiEnergyFluidProducer(ResourceLocation texture, T container, Inventory playerInventory, Component title) {
        super(texture, container, playerInventory, title);
        this.playerInv = playerInventory;
        this.tile = ((ContainerEnergyFluidProducer)((Object)container)).getTile();
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public String getUnlocalizedTooltipEnergy() {
        return "tooltip.energy";
    }

    public String getUnlocalizedTooltipProgress() {
        return "tooltip.progress";
    }

    public abstract String getUnlocalizedTooltipLiquid();

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.getTitle().getVisualOrderText(), 38, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        if (mouseX >= this.leftPos + 11 && mouseX <= this.leftPos + 16 + 11 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)this.getUnlocalizedTooltipEnergy(), (Object[])new Object[]{this.tile.getStoredEnergy()}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
        if (mouseX >= this.leftPos + 148 && mouseX <= this.leftPos + 16 + 148 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList();
            list.add(Component.translatable((String)this.getUnlocalizedTooltipLiquid(), (Object[])new Object[]{this.tile.getCurrentMillibuckets()}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
        if (mouseX >= this.leftPos + 79 && mouseX <= this.leftPos + 24 + 79 && mouseY >= this.topPos + 34 && mouseY <= this.topPos + 17 + 34) {
            list = new ArrayList();
            list.add(Component.translatable((String)this.getUnlocalizedTooltipProgress(), (Object[])new Object[]{(int)(this.getProgress() * 100.0f)}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    public void drawEnergy(GuiGraphics guiGraphics) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid(GuiGraphics guiGraphics) {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 148;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress(GuiGraphics guiGraphics) {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.texture, i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.getMaxEnergy();
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.getFluidAmount();
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        return (float)this.tile.getGeneratingTime() / (float)this.tile.getTimeToGenerate();
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawEnergy(guiGraphics);
        this.drawFluid(guiGraphics);
        this.drawProgress(guiGraphics);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

