/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class TileentitySpecialRendererGasStation
implements BlockEntityRenderer<TileEntityGasStation> {
    private Minecraft minecraft;
    protected BlockEntityRendererProvider.Context renderer;

    public TileentitySpecialRendererGasStation(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
        this.minecraft = Minecraft.getInstance();
    }

    public void render(TileEntityGasStation target, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!target.hasLevel()) {
            return;
        }
        String name = target.getRenderText();
        if (name == null || name.isEmpty()) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.0, 0.5);
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        Direction dir = target.getDirection();
        matrixStack.mulPose(Axis.YP.rotationDegrees(dir.toYRot()));
        Font font = this.renderer.getFont();
        int textWidth = font.width(name);
        float textScale = 0.36f / (float)textWidth;
        textScale = Math.min(textScale, 0.01f);
        float posX = -(textScale * (float)textWidth) / 2.0f;
        matrixStack.translate((double)posX, -0.815, -0.188);
        matrixStack.scale(textScale, textScale, textScale);
        font.drawInBatch(name, 0.0f, 0.0f, 0, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        matrixStack.popPose();
        if (this.minecraft.getEntityRenderDispatcher().shouldRenderHitBoxes() && !Minecraft.getInstance().showOnlyReducedInfo()) {
            matrixStack.pushPose();
            this.renderBoundingBox(target, partialTicks, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
            matrixStack.popPose();
        }
    }

    public void renderBoundingBox(TileEntityGasStation target, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        AABB axisalignedbb = target.getDetectionBox().move((double)(-target.getBlockPos().getX()), (double)(-target.getBlockPos().getY()), (double)(-target.getBlockPos().getZ()));
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)axisalignedbb, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
    }

    public AABB getRenderBoundingBox(TileEntityGasStation blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

