/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.corelib.client.RenderUtils;
import de.maxhenkel.car.fluids.ModFluids;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class TileEntitySpecialRendererSplitTank
implements BlockEntityRenderer<TileEntitySplitTank> {
    private static final FluidStack BIO_DIESEL_STACK = new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), 1);
    private static final FluidStack GLYCERIN_STACK = new FluidStack((Fluid)ModFluids.GLYCERIN.get(), 1);
    protected BlockEntityRendererProvider.Context renderer;

    public TileEntitySpecialRendererSplitTank(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public void render(TileEntitySplitTank te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.pushPose();
        float bioDiesel = te.getBioDieselPerc() / 2.0f;
        float glycerin = te.getGlycerinPerc() / 2.0f;
        if (bioDiesel > 0.0f) {
            this.renderFluid(BIO_DIESEL_STACK, bioDiesel, 0.0625f, matrixStack, buffer, light, overlay);
        }
        if (glycerin > 0.0f) {
            this.renderFluid(GLYCERIN_STACK, glycerin, bioDiesel + 0.0625f, matrixStack, buffer, light, overlay);
        }
        matrixStack.popPose();
    }

    public void renderFluid(FluidStack fluid, float amount, float yStart, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.pushPose();
        matrixStack.scale(0.98f, 0.98f, 0.98f);
        matrixStack.translate(0.01f, 0.01f, 0.01f);
        VertexConsumer builder = buffer.getBuffer(Sheets.translucentItemSheet());
        IClientFluidTypeExtensions type = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite texture = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(type.getStillTexture(fluid));
        float uMin = texture.getU0();
        float uMax = texture.getU1();
        float vMin = texture.getV0();
        float vMax = texture.getV1();
        float vHeight = vMax - vMin;
        float s = 0.0f;
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, light, overlay);
        matrixStack.popPose();
    }
}

