/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockFluidExtractor;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.fluid.FluidUtils;
import de.maxhenkel.tools.BlockPosList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityFluidExtractor
extends TileEntityBase
implements ITickableBlockEntity {
    private IFluidHandler extractHandler;
    private final int drainSpeed;
    private ItemStack filter;

    public TileEntityFluidExtractor(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.FLUID_EXTRACTOR_TILE_ENTITY_TYPE.get(), pos, state);
        this.drainSpeed = (Integer)Main.SERVER_CONFIG.fluidExtractorDrainSpeed.get();
        this.filter = null;
    }

    @Nullable
    public Fluid getFilterFluid() {
        if (this.filter == null) {
            return null;
        }
        FluidStack stack = FluidUtil.getFluidContained((ItemStack)this.filter).orElse(null);
        if (stack == null || stack.getAmount() <= 0) {
            return null;
        }
        return stack.getFluid();
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        this.updateExtractHandler();
        if (this.extractHandler == null) {
            return;
        }
        FluidStack drainSimulated = this.getFilterFluid() == null ? this.extractHandler.drain(this.drainSpeed, IFluidHandler.FluidAction.SIMULATE) : this.extractHandler.drain(new FluidStack(this.getFilterFluid(), this.drainSpeed), IFluidHandler.FluidAction.SIMULATE);
        if (drainSimulated.getAmount() <= 0) {
            return;
        }
        LinkedList<IFluidHandler> handlers = new LinkedList<IFluidHandler>();
        this.getConnectedHandlers(handlers, new BlockPosList(), this.worldPosition);
        LinkedList<IFluidHandler> fillHandlers = new LinkedList<IFluidHandler>();
        for (IFluidHandler handler : handlers) {
            int amount = handler.fill(drainSimulated, IFluidHandler.FluidAction.SIMULATE);
            if (amount <= 0) continue;
            fillHandlers.add(handler);
        }
        if (fillHandlers.isEmpty()) {
            return;
        }
        for (IFluidHandler handler : fillHandlers) {
            if (this.getFilterFluid() == null) {
                FluidUtils.tryFluidTransfer(handler, this.extractHandler, this.drainSpeed, true);
                continue;
            }
            FluidUtils.tryFluidTransfer(handler, this.extractHandler, this.drainSpeed, true, this.getFilterFluid());
        }
    }

    public void updateExtractHandler() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (!state.getBlock().equals(ModBlocks.FLUID_EXTRACTOR.get())) {
            this.extractHandler = null;
            return;
        }
        Direction side = (Direction)state.getValue((Property)BlockFluidExtractor.FACING);
        this.extractHandler = FluidUtils.getFluidHandlerOffset(this.level, this.worldPosition, side);
    }

    public void getConnectedHandlers(List<IFluidHandler> handlers, BlockPosList positions, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockPos p = pos.relative(side);
            if (positions.contains(p)) continue;
            BlockState state = this.level.getBlockState(p);
            if (state.getBlock().equals(ModBlocks.FLUID_PIPE.get()) || state.getBlock().equals(ModBlocks.FLUID_EXTRACTOR.get())) {
                positions.add(p);
                this.getConnectedHandlers(handlers, positions, p);
                continue;
            }
            IFluidHandler handler = FluidUtils.getFluidHandlerOffset(this.level, pos, side);
            if (handler == null || handler.equals((Object)this.extractHandler)) continue;
            handlers.add(handler);
        }
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.filter != null) {
            compound.put("filter", this.filter.saveOptional(provider));
        }
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("filter")) {
            CompoundTag tag = compound.getCompound("filter");
            this.filter = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
        } else {
            this.filter = null;
        }
        super.loadAdditional(compound, provider);
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.fluid_extractor");
    }

    public ItemStack getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.copy();
    }

    public void setFilter(ItemStack filter) {
        if (filter == null) {
            this.filter = null;
            this.setChanged();
            this.synchronize();
            return;
        }
        this.filter = filter.copy();
        this.setChanged();
        this.synchronize();
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

