/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.recipes.EnergyFluidProducerRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class TileEntityEnergyFluidProducer
extends TileEntityBase
implements IEnergyStorage,
WorldlyContainer,
ITickableBlockEntity,
IFluidHandler,
RecipeInput {
    protected RecipeType<? extends EnergyFluidProducerRecipe> recipeType;
    protected SimpleContainer inventory;
    protected int maxEnergy;
    protected int storedEnergy;
    protected int time;
    protected int fluidAmount;
    protected int currentMillibuckets;
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntityEnergyFluidProducer.this.time;
                }
                case 1: {
                    return TileEntityEnergyFluidProducer.this.storedEnergy;
                }
                case 2: {
                    return TileEntityEnergyFluidProducer.this.currentMillibuckets;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityEnergyFluidProducer.this.time = value;
                    break;
                }
                case 1: {
                    TileEntityEnergyFluidProducer.this.storedEnergy = value;
                    break;
                }
                case 2: {
                    TileEntityEnergyFluidProducer.this.currentMillibuckets = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public TileEntityEnergyFluidProducer(BlockEntityType<?> tileEntityTypeIn, RecipeType<? extends EnergyFluidProducerRecipe> recipeType, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.recipeType = recipeType;
        this.inventory = new SimpleContainer(2);
        this.maxEnergy = 10000;
        this.storedEnergy = 0;
        this.time = 0;
        this.fluidAmount = 3000;
        this.currentMillibuckets = 0;
    }

    public EnergyFluidProducerRecipe getRecipe() {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)this, this.level).map(recipeHolder -> (EnergyFluidProducerRecipe)recipeHolder.value()).orElse(null);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        ItemStack input = this.inventory.getItem(0);
        ItemStack output = this.inventory.getItem(1);
        EnergyFluidProducerRecipe recipe = this.getRecipe();
        if (recipe == null) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        if (this.storedEnergy < recipe.getEnergy()) {
            this.setBlockEnabled(false);
            return;
        }
        if (input.isEmpty()) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        if (!(output.isEmpty() || ItemStack.isSameItem((ItemStack)output, (ItemStack)recipe.getResultItem()) && output.getCount() + recipe.getResultItem().getCount() <= output.getMaxStackSize())) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        if (this.currentMillibuckets + recipe.getFluidAmount() > this.fluidAmount) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        ++this.time;
        this.storedEnergy -= recipe.getEnergy();
        if (this.time > recipe.getDuration()) {
            this.time = 0;
            if (output.isEmpty()) {
                this.inventory.setItem(1, recipe.getResultItem());
            } else if (output.getCount() < output.getMaxStackSize()) {
                output.grow(recipe.getResultItem().getCount());
            }
            this.currentMillibuckets += recipe.getFluidAmount();
            input.shrink(1);
        }
        this.setChanged();
        this.setBlockEnabled(true);
    }

    public abstract BlockGui<? extends TileEntityEnergyFluidProducer> getOwnBlock();

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.level.getBlockState(this.getBlockPos());
        if (state.getBlock().equals(this.getOwnBlock())) {
            this.getOwnBlock().setPowered(this.level, this.worldPosition, state, enabled);
        }
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("energy_stored", this.storedEnergy);
        compound.putInt("time", this.time);
        compound.putInt("fluid_stored", this.currentMillibuckets);
        ItemUtils.saveInventory(provider, compound, "slots", (Container)this.inventory);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.storedEnergy = compound.getInt("energy_stored");
        this.time = compound.getInt("time");
        this.currentMillibuckets = compound.getInt("fluid_stored");
        ItemUtils.readInventory(provider, compound, "slots", (Container)this.inventory);
        super.loadAdditional(compound, provider);
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void startOpen(Player player) {
        this.inventory.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.inventory.stopOpen(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{0, 1};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return index == 0;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getTimeToGenerate() {
        EnergyFluidProducerRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return 0;
        }
        return recipe.getDuration();
    }

    public int getGeneratingTime() {
        return this.time;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    public abstract Fluid getProducingFluid();

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyNeeded = this.maxEnergy - this.storedEnergy;
        if (!simulate) {
            this.storedEnergy += Math.min(energyNeeded, maxReceive);
            this.setChanged();
        }
        return Math.min(energyNeeded, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(this.getProducingFluid(), this.currentMillibuckets);
    }

    public int getTankCapacity(int tank) {
        return this.fluidAmount;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return stack.getFluid().equals(this.getProducingFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = Math.min(resource.getAmount(), this.currentMillibuckets);
        if (action.execute()) {
            this.currentMillibuckets -= amount;
            this.setChanged();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int amount = Math.min(maxDrain, this.currentMillibuckets);
        if (action.execute()) {
            this.currentMillibuckets -= amount;
            this.setChanged();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }

    public int size() {
        return 1;
    }
}

