/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockGasStationTop;
import de.maxhenkel.car.blocks.BlockOrientableHorizontal;
import de.maxhenkel.car.blocks.BlockTank;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.block.DirectionalVoxelShape;
import de.maxhenkel.car.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.car.gui.ContainerGasStation;
import de.maxhenkel.car.gui.ContainerGasStationAdmin;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockGasStation
extends BlockOrientableHorizontal {
    public static VoxelShape SHAPE_NORTH_SOUTH = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)31.0, (double)11.0);
    public static VoxelShape SHAPE_EAST_WEST = Block.box((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)31.0, (double)14.0);
    public static VoxelShape SHAPE_SLAB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.01, (double)16.0);
    private static final DirectionalVoxelShape SHAPES = new DirectionalVoxelShape.Builder().direction(Direction.NORTH, SHAPE_NORTH_SOUTH, SHAPE_SLAB).direction(Direction.SOUTH, SHAPE_NORTH_SOUTH, SHAPE_SLAB).direction(Direction.EAST, SHAPE_EAST_WEST, SHAPE_SLAB).direction(Direction.WEST, SHAPE_EAST_WEST, SHAPE_SLAB).build();

    public BlockGasStation() {
        super(MapColor.METAL, SoundType.METAL, 4.0f, 50.0f);
    }

    @Override
    public Item toItem() {
        return new BlockItem(this, this, new Item.Properties()){

            protected boolean canPlace(BlockPlaceContext context, BlockState state) {
                if (!context.getLevel().isEmptyBlock(context.getClickedPos().above())) {
                    return false;
                }
                return super.canPlace(context, state);
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity te = level.getBlockEntity(blockPos);
        if (!(te instanceof TileEntityGasStation)) {
            return ItemInteractionResult.FAIL;
        }
        TileEntityGasStation station = (TileEntityGasStation)te;
        ItemStack stack = player.getItemInHand(interactionHand);
        if (station.isOwner(player) || !station.hasTrade()) {
            boolean success1;
            boolean success;
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (!fluidStack.isEmpty() && (success = BlockTank.handleEmpty(stack, level, blockPos, player, interactionHand))) {
                return ItemInteractionResult.SUCCESS;
            }
            IFluidHandler handler = FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
            if (handler != null && (success1 = BlockTank.handleFill(stack, level, blockPos, player, interactionHand))) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (!player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                TileEntityContainerProvider.openGui((ServerPlayer)player, station, (i, playerInventory, playerEntity) -> new ContainerGasStation(i, station, playerInventory));
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (station.isOwner(player)) {
            if (player instanceof ServerPlayer) {
                TileEntityContainerProvider.openGui((ServerPlayer)player, station, (i, playerInventory, playerEntity) -> new ContainerGasStationAdmin(i, station, playerInventory));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Direction)state.getValue((Property)FACING));
    }

    @Override
    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        if (worldIn.isEmptyBlock(pos.above())) {
            BlockGasStationTop cfr_ignored_0 = (BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get());
            worldIn.setBlockAndUpdate(pos.above(), (BlockState)((BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get())).defaultBlockState().setValue((Property)BlockGasStationTop.FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
        }
        if ((te = worldIn.getBlockEntity(pos)) instanceof TileEntityGasStation && placer instanceof Player) {
            TileEntityGasStation station = (TileEntityGasStation)te;
            station.setOwner((Player)placer);
        }
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, worldIn, pos, newState, isMoving);
        BlockState stateUp = worldIn.getBlockState(pos.above());
        stateUp.getBlock();
        if (stateUp.getBlock().equals(ModBlocks.GAS_STATION_TOP.get())) {
            worldIn.destroyBlock(pos.above(), false);
        }
        BlockGasStation.dropItems(worldIn, pos);
    }

    public static void dropItems(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof TileEntityGasStation) {
            TileEntityGasStation station = (TileEntityGasStation)te;
            Containers.dropContents((Level)worldIn, (BlockPos)pos, (Container)station.getInventory());
            Containers.dropContents((Level)worldIn, (BlockPos)pos, (Container)station.getTradingInventory());
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TileEntityGasStation(blockPos, blockState);
    }
}

